<?php
// Script para crear un usuario admin con contraseña válida
require_once 'config/database.php';

$database = new Database();
$db = $database->getConnection();

// Contraseña: Admin123
$password = 'Admin123';
$hashed_password = password_hash($password, PASSWORD_BCRYPT);

echo "<h2>Generando Usuario Admin</h2>";
echo "Contraseña original: " . $password . "<br>";
echo "Hash generado: " . $hashed_password . "<br><br>";

// Verificar si el hash funciona
if (password_verify($password, $hashed_password)) {
    echo "✓ Hash verificado correctamente<br>";
} else {
    echo "✗ Error en la verificación del hash<br>";
}

// Insertar o actualizar usuario admin
$query = "INSERT INTO usuarios (dni, apellidos, nombres, password, correo, area_id, tipo_usuario, email_verificado) 
          VALUES ('admin123', 'Administrador', 'Sistema', :password, 'admin@sistema.com', 1, 'admin', 1)
          ON DUPLICATE KEY UPDATE password = :password";

$stmt = $db->prepare($query);
$stmt->bindParam(':password', $hashed_password);

if ($stmt->execute()) {
    echo "<br>✓ Usuario admin creado/actualizado correctamente<br>";
    echo "<br><strong>Credenciales:</strong><br>";
    echo "DNI: admin123<br>";
    echo "Contraseña: Admin123<br>";
} else {
    echo "<br>✗ Error al crear/actualizar usuario<br>";
}

// Verificar que el usuario existe
$query = "SELECT * FROM usuarios WHERE dni = 'admin123'";
$stmt = $db->prepare($query);
$stmt->execute();
$usuario = $stmt->fetch(PDO::FETCH_ASSOC);

echo "<br><strong>Usuario en la base de datos:</strong><br>";
print_r($usuario);
?>