<?php
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require 'vendor/autoload.php'; // Requiere instalar PHPMailer via Composer

class EmailSender {
    private $mail;
    
    public function __construct() {
        $this->mail = new PHPMailer(true);
        $this->configurar();
    }
    
    private function configurar() {
        // Configuración del servidor
        $this->mail->isSMTP();
        $this->mail->Host = 'smtp.gmail.com';
        $this->mail->SMTPAuth = true;
        $this->mail->Username = 'rci.ugelviru@gmail.com';
        $this->mail->Password = 'xayq zsnn uktw msey';
        $this->mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
        $this->mail->Port = 587;
        
        // Configuración del remitente
        $this->mail->setFrom('rci.ugelviru@gmail.com', 'Sistema de Visitas');
        $this->mail->isHTML(true);
    }
    
    public function enviarVerificacion($email, $nombre, $token) {
        try {
            $this->mail->addAddress($email, $nombre);
            $this->mail->Subject = 'Verifica tu cuenta - Sistema de Visitas';
            
            $url = "http://" . $_SERVER['HTTP_HOST'] . "/verificar.php?token=" . $token;
            
            $message = "
                <html>
                <head>
                    <title>Verificación de Cuenta</title>
                </head>
                <body style='font-family: Arial, sans-serif;'>
                    <div style='background-color: #e3f2fd; padding: 20px; border-radius: 5px;'>
                        <h2 style='color: #1976d2;'>¡Bienvenido al Sistema de Visitas!</h2>
                        <p>Hola $nombre,</p>
                        <p>Gracias por registrarte en nuestro sistema. Para activar tu cuenta, por favor haz clic en el siguiente enlace:</p>
                        <p style='text-align: center; margin: 30px 0;'>
                            <a href='$url' style='background-color: #1976d2; color: white; padding: 12px 24px; text-decoration: none; border-radius: 5px;'>Verificar Cuenta</a>
                        </p>
                        <p>Si no solicitaste este registro, por favor ignora este mensaje.</p>
                        <hr>
                        <p style='color: #666; font-size: 12px;'>Este es un mensaje automático, por favor no respondas a este correo.</p>
                    </div>
                </body>
                </html>
            ";
            
            $this->mail->Body = $message;
            $this->mail->send();
            return true;
        } catch (Exception $e) {
            error_log("Error al enviar email: " . $this->mail->ErrorInfo);
            return false;
        }
    }
    
    public function enviarRecuperacion($email, $nombre, $token) {
        try {
            $this->mail->addAddress($email, $nombre);
            $this->mail->Subject = 'Recuperación de Contraseña - Sistema de Visitas';
            
            $url = "http://" . $_SERVER['HTTP_HOST'] . "/reset_password.php?token=" . $token;
            
            $message = "
                <html>
                <head>
                    <title>Recuperación de Contraseña</title>
                </head>
                <body style='font-family: Arial, sans-serif;'>
                    <div style='background-color: #fff3cd; padding: 20px; border-radius: 5px; border: 1px solid #ffeaa7;'>
                        <h2 style='color: #856404;'>Recuperación de Contraseña</h2>
                        <p>Hola $nombre,</p>
                        <p>Hemos recibido una solicitud para restablecer tu contraseña. Si fuiste tú, haz clic en el siguiente enlace:</p>
                        <p style='text-align: center; margin: 30px 0;'>
                            <a href='$url' style='background-color: #856404; color: white; padding: 12px 24px; text-decoration: none; border-radius: 5px;'>Restablecer Contraseña</a>
                        </p>
                        <p>Este enlace expirará en 1 hora.</p>
                        <p>Si no solicitaste restablecer tu contraseña, por favor ignora este mensaje.</p>
                        <hr>
                        <p style='color: #666; font-size: 12px;'>Este es un mensaje automático, por favor no respondas a este correo.</p>
                    </div>
                </body>
                </html>
            ";
            
            $this->mail->Body = $message;
            $this->mail->send();
            return true;
        } catch (Exception $e) {
            error_log("Error al enviar email: " . $this->mail->ErrorInfo);
            return false;
        }
    }
}
?>