<?php
session_start();

// Redireccionar si no está autenticado
if (!isset($_SESSION['user_id'])) {
    // Guardar la URL actual para redireccionar después del login
    $_SESSION['redirect_url'] = $_SERVER['REQUEST_URI'];
    
    // Mostrar mensaje
    $_SESSION['mensaje'] = "Por favor inicia sesión para acceder a esta página";
    $_SESSION['tipo_mensaje'] = "warning";
    
    header("Location: ../login.php");
    exit();
}

// Verificar si el usuario está activo (opcional)
require_once '../config/database.php';
$database = new Database();
$db = $database->getConnection();

$query = "SELECT activo FROM usuarios WHERE id = :id";
$stmt = $db->prepare($query);
$stmt->bindParam(':id', $_SESSION['user_id']);
$stmt->execute();

if ($stmt->rowCount() == 1) {
    $row = $stmt->fetch(PDO::FETCH_ASSOC);
    if ($row['activo'] == 0) {
        // Usuario inactivo, cerrar sesión
        session_destroy();
        header("Location: ../login.php?error=inactivo");
        exit();
    }
}

// Verificar permisos de administrador (para páginas específicas)
function verificarAdmin() {
    if ($_SESSION['user_tipo'] != 'admin') {
        $_SESSION['mensaje'] = "No tienes permisos para acceder a esta sección";
        $_SESSION['tipo_mensaje'] = "danger";
        header("Location: ../dashboard.php");
        exit();
    }
}

// Verificar permisos de registrador
function verificarRegistrador() {
    if ($_SESSION['user_tipo'] != 'registrador' && $_SESSION['user_tipo'] != 'admin') {
        $_SESSION['mensaje'] = "No tienes permisos para acceder a esta sección";
        $_SESSION['tipo_mensaje'] = "danger";
        header("Location: ../dashboard.php");
        exit();
    }
}
?>